//******************************************************************************
//  Jose I Quinones
//  Texas Instruments Inc.
//  June 2009
//  Built with IAR Embedded Workbench Version: 3.42A
//******************************************************************************
//***********************************************************************************
// App Extern Globals                                                               *
//***********************************************************************************
extern int StatusLED;
extern char AccelerateState;
extern unsigned int SteppingRate, SteppingRateTMR, StartingSpeed, StoppingSpeed, DesiredStepperSpeed;
extern unsigned int AccelRate, tmpAccelTimeBaseScale, AccelTimeBaseScale, AccelTimeBaseTMR, AccelerationIncrease;
extern unsigned int StepsToStop, StepsToMove, tmpStepsToMove;

extern bool MoveSteps, AccelerateTrue;

//***********************************************************************************
// Firmware Revision                                                                *
//***********************************************************************************
#define     FIRMWARE_RELEASE    0
#define     FIRMWARE_REVISION   2
//***********************************************************************************
// Application Specific Hardware Definitions                                        *
//***********************************************************************************
#define     StatusLEDPin    0x20

#define     P1OUT_INIT  0
#define     P2OUT_INIT  0
#define     P3OUT_INIT  0
#define     P4OUT_INIT  0
#define     P5OUT_INIT  0
#define     P6OUT_INIT  0

//***********************************************************************************
// Application Specific Definitions                                                 *
//***********************************************************************************
#define     OPCODE      SerialBuffer[0]

#define     NOACC       0
#define     ACCEL       1
#define     DECEL       2
#define     STOP        3
#define     STEPS_STOP  4

#define       MAIN_CLK_MHZ          8000000           //For 8MHz Timers
#define       HALF_MAIN_CLK_MHZ     MAIN_CLK_MHZ/2
#define       QUAD_MAIN_CLK_MHZ     MAIN_CLK_MHZ/4
#define       EIGHT_MAIN_CLK_MHZ    MAIN_CLK_MHZ/8

#define       ACCEL_INCREASE_1      123
#define       ACCEL_INCREASE_2      62
#define       ACCEL_INCREASE_4      31
#define       ACCEL_INCREASE_8      2
//***********************************************************************************
// Application Specific Opcodes                                                     *
//***********************************************************************************
#define     WRITE_GPIO      0x03
#define     DAC0_UPDATE     0x05
#define     DAC1_UPDATE     0x06
#define     DISABLE_PWM     0x0C
#define     SET_TMR_OUT     0x0E
#define     PULSE_TMR       0x0F
#define     START_STEPPER   0x12
#define     STOP_STEPPER    0x13
#define     STEPPER_SPEED   0x14
#define     MOVE_STEPS      0x15
#define     STEPPER_CONFIG  0x16
#define     CONFIG_STEPS    0x17

//Memory Access Opcodes
#define     READ_MEM        0xE0
#define     WRITE_WMEM      0xE1
#define     WRITE_BMEM      0xE2

// System Opcodes
#define     GET_FW_REV      0xF0
#define     RESET_MCU       0xF1

//***********************************************************************************
// Application Specific Externs                                                     *
//***********************************************************************************
